<?php include("views/components/head.inc.php"); ?>

<div class="min-h-screen flex items-center justify-center bg-gray-100 py-12 px-4 sm:px-6 lg:px-8">
    <div class="max-w-md w-full space-y-8 bg-white p-8 shadow rounded">
        <h2 class="mt-2 text-center text-3xl font-extrabold text-gray-900">
            Connexion à l’administration
        </h2>

        <!-- MESSAGES -->
        <?php if (!empty($_GET["erreur"])): ?>
            <div class="bg-red-100 text-red-700 p-3 rounded text-sm">
                <?php
                    switch ($_GET["erreur"]) {
                        case "identifiants_invalides":
                            echo "Identifiants invalides. Veuillez réessayer.";
                            break;
                        case "champs_obligatoires":
                            echo "Veuillez remplir tous les champs.";
                            break;
                        default:
                            echo "Une erreur est survenue.";
                    }
                ?>
            </div>
        <?php endif; ?>

        <?php if (!empty($_GET["succes_deconnexion"])): ?>
            <div class="bg-green-100 text-green-700 p-3 rounded text-sm">
                Déconnexion réussie.
            </div>
        <?php endif; ?>

        <!-- FORMULAIRE -->
        <form class="mt-6 space-y-6" action="connecter" method="POST">
            <div>
                <label for="courriel" class="block text-sm font-medium text-gray-700">Courriel</label>
                <input 
                    id="courriel"
                    name="courriel"
                    type="email"
                    required
                    autofocus
                    value="<?= htmlspecialchars($_POST['courriel'] ?? '') ?>"
                    class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm placeholder-gray-400 focus:outline-none focus:ring-[#3B3E2E] focus:border-[#3B3E2E] sm:text-sm"
                >
            </div>

            <div>
                <label for="mdp" class="block text-sm font-medium text-gray-700">Mot de passe</label>
                <input 
                    id="mdp"
                    name="mdp"
                    type="password"
                    required
                    autocomplete="off"
                    class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm placeholder-gray-400 focus:outline-none focus:ring-[#3B3E2E] focus:border-[#3B3E2E] sm:text-sm"
                >
            </div>

            <div>
                <button 
                    type="submit" 
                    class="w-full flex justify-center py-2 px-4 border border-transparent rounded-md shadow-sm text-white bg-[#3B3E2E] hover:bg-[#2d2f20] focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-[#3B3E2E]">
                    Se connecter
                </button>
            </div>
        </form>
    </div>
</div>

<?php include("views/components/foot.inc.php"); ?>
