<?php include("views/components/head.inc.php") ?>

<main class="min-h-screen bg-gray-100 py-10 px-4 flex flex-col items-center">
    <div class="max-w-4xl w-full bg-white rounded shadow-md p-6">
        <h1 class="text-3xl font-bold text-gray-800 mb-6 text-center">Liste des utilisateurs</h1>

        <!-- Messages de succès -->
        <?php if (isset($_GET["succes_suppression"])): ?>
            <div class="bg-green-100 text-green-700 p-3 mb-4 rounded text-center text-sm">Utilisateur supprimé avec succès.</div>
        <?php endif; ?>
        <?php if (isset($_GET["succes_creation"])): ?>
            <div class="bg-green-100 text-green-700 p-3 mb-4 rounded text-center text-sm">Utilisateur créé avec succès.</div>
        <?php endif; ?>
        <?php if (isset($_GET["succes_modification"])): ?>
            <div class="bg-green-100 text-green-700 p-3 mb-4 rounded text-center text-sm">Utilisateur modifié avec succès.</div>
        <?php endif; ?>

        <!-- Bouton retour -->
        <div class="mb-6">
            <a href="admin" class="inline-block bg-gray-200 text-gray-800 px-4 py-2 rounded hover:bg-gray-300 transition">
                ← Retour au tableau de bord
            </a>
        </div>

        <!-- Liste des utilisateurs -->
        <?php if (!empty($utilisateurs)) : ?>
            <ul class="space-y-4">
                <?php foreach ($utilisateurs as $utilisateur) : ?>
                    <li class="flex items-center justify-between bg-gray-50 p-4 rounded shadow-sm">
                        <div>
                            <span class="font-semibold"><?= htmlspecialchars($utilisateur->nom) ?></span>
                            <span class="text-sm text-gray-500">(<?= htmlspecialchars($utilisateur->role) ?>)</span>
                        </div>
                        <div class="flex gap-3">
                            <a href="utilisateurs-modifier?id=<?= $utilisateur->id ?>" class="text-blue-600 hover:underline" aria-label="Modifier utilisateur">
                                Modifier
                            </a>
                            <a href="utilisateurs-supprimer?id=<?= $utilisateur->id ?>" onclick="return confirm('Confirmer la suppression ?');" class="text-red-600 hover:underline" aria-label="Supprimer utilisateur">
                                Supprimer
                            </a>
                        </div>
                    </li>
                <?php endforeach; ?>
            </ul>
        <?php else: ?>
            <p class="text-gray-600 text-center mt-6">Aucun utilisateur trouvé.</p>
        <?php endif; ?>

        <!-- Ajouter un utilisateur -->
        <div class="mt-8 text-center">
            <a href="utilisateurs-creer" class="inline-block bg-[#3B3E2E] text-white px-5 py-2 rounded hover:bg-[#2c2f20] transition">
                Ajouter un nouvel utilisateur
            </a>
        </div>
    </div>
</main>

<?php include("views/components/foot.inc.php") ?>
