<?php include("views/components/head.inc.php") ?>

<main class="min-h-screen bg-gray-100 py-10 px-4 flex flex-col items-center">
    <div class="max-w-xl w-full bg-white rounded shadow-md p-6">
        <h1 class="text-3xl font-bold text-gray-800 mb-6 text-center">
            Modifier l'utilisateur <?= htmlspecialchars($utilisateur->nom) ?>
        </h1>

        <!-- Messages -->
        <?php if (isset($_GET["infos_requises"])): ?>
            <div class="bg-red-100 text-red-700 p-3 mb-4 rounded text-center text-sm">
                Veuillez remplir tous les champs requis.
            </div>
        <?php endif; ?>

        <?php if (isset($_GET["succes_modification"])): ?>
            <div class="bg-green-100 text-green-700 p-3 mb-4 rounded text-center text-sm">
                Utilisateur modifié avec succès.
            </div>
        <?php endif; ?>

        <!-- Formulaire -->
        <form action="utilisateurs-mettre-a-jour" method="post" class="space-y-5">
            <input type="hidden" name="id" value="<?= $utilisateur->id ?>">

            <div>
                <label for="nom" class="block text-sm font-medium text-gray-700">Nom</label>
                <input type="text" id="nom" name="nom" required
                    value="<?= htmlspecialchars($utilisateur->nom) ?>"
                    class="mt-1 w-full border border-gray-300 rounded px-3 py-2 focus:outline-none focus:ring-2 focus:ring-[#3B3E2E]">
            </div>

            <div>
                <label for="courriel" class="block text-sm font-medium text-gray-700">Courriel</label>
                <input type="email" id="courriel" name="courriel" required
                    value="<?= htmlspecialchars($utilisateur->courriel) ?>"
                    class="mt-1 w-full border border-gray-300 rounded px-3 py-2 focus:outline-none focus:ring-2 focus:ring-[#3B3E2E]">
            </div>

            <div>
                <label for="role" class="block text-sm font-medium text-gray-700">Rôle</label>
                <select id="role" name="role"
                    class="mt-1 w-full border border-gray-300 rounded px-3 py-2 focus:outline-none focus:ring-2 focus:ring-[#3B3E2E]">
                    <option value="employe" <?= $utilisateur->role === "employe" ? "selected" : "" ?>>Employé</option>
                    <option value="proprietaire" <?= $utilisateur->role === "proprietaire" ? "selected" : "" ?>>Propriétaire</option>
                </select>
            </div>

            <div class="flex justify-between items-center mt-6">
                <a href="utilisateurs" class="text-sm text-gray-600 hover:underline">← Annuler</a>
                <button type="submit" class="bg-[#3B3E2E] text-white px-6 py-2 rounded hover:bg-[#2c2f20] transition">
                    Modifier
                </button>
            </div>
        </form>
    </div>
</main>

<?php include("views/components/foot.inc.php") ?>
