<?php $titre = "Menu | Pub G6"; ?>
<?php include("views/components/head.inc.php"); ?>

<!-- NAVBAR -->
<nav class="sticky top-0 left-0 w-full bg-[#3B3E2E]/80 font-texte z-50">
  <div class="max-w-7xl mx-auto px-4 py-4 flex justify-between items-center">

    <!-- Logo -->
    <div>
      <a href="accueil#accueil">
        <img src="public/img/logo.png" alt="Logo Pub G6" class="h-12">
      </a>
    </div>

    <!-- Bouton hamburger (mobile) -->
    <button id="menu-btn" class="md:hidden text-white focus:outline-none">
      <svg class="w-8 h-8" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
        <path stroke-linecap="round" stroke-linejoin="round" d="M4 6h16M4 12h16M4 18h16" />
      </svg>
    </button>

    <!-- Liens -->
    <ul id="menu-list" class="hidden md:flex flex-col md:flex-row space-y-4 md:space-y-0 md:space-x-6 
      text-white text-sm font-medium absolute md:static bg-[#3B3E2E] md:bg-transparent 
      w-full left-0 top-20 px-4 md:px-0 md:w-auto z-40">

      <li><a href="accueil" class="hover:text-[#4D280C] transition block py-2">ACCUEIL</a></li>
      <li><a href="menu" class="hover:text-[#4D280C] transition block py-2">MENU</a></li>
      <li><a href="accueil#contact" class="hover:text-[#4D280C] transition block py-2">CONTACT</a></li>
      <li><a href="accueil#apropos" class="hover:text-[#4D280C] transition block py-2">À PROPOS</a></li>
    </ul>

  </div>
</nav>



<!-- HERO POUR LA PAGE MENU -->
<header class="relative w-full h-screen bg-cover bg-center" style="background-image: url('public/img/hero1.jpg');">
  <!-- Conteneur centré -->
  <div class="absolute inset-0 flex flex-col justify-center items-center text-center px-4">
    
    <!-- Boîte semi-transparente autour du titre -->
    <div class="bg-[#323122]/70 px-4 py-2 rounded">
      <h1 class="font-source-sans-pro font-bold text-[24px] sm:text-[24px] md:text-[34px] lg:text-[44px] xl:text-[52px] text-white">
        Notre menu
      </h1>
    </div>

    <!-- Flèche blanche animée -->
    <div class="mt-12 animate-bounce">
          <a href="#entrées">
      <svg xmlns="http://www.w3.org/2000/svg" class="h-20 w-20 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
          </a>
      </svg>
    </div>
</header>




<!-- MENU -->
<div class="max-w-[1300px] mx-auto px-6 pt-10">
<?php foreach ($categories as $categorie): ?>
    <section id='entrées' class="mb-20">
        <!-- Image avec nom de catégorie -->
        <div class="relative rounded-lg overflow-hidden">
            <img src="public/img/<?= htmlspecialchars($categorie->image) ?>" alt="<?= htmlspecialchars($categorie->nom) ?>" class="w-full h-[500px] object-cover">
            <div class="absolute inset-0 bg-black/40 flex items-center justify-center">
                <h2 class="text-white text-5xl font-title"><?= $categorie->nom ?></h2>
            </div>
        </div>

        <!-- Plats de la catégorie -->
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-5 gap-12 mt-12 max-w-[1300px] mx-auto">
            <?php foreach ($categorie->plats as $plat): ?>
                <div class="text-left">
                    <h3 class="text-2xl font-semibold text-[#3B3E2E]-800"><?= $plat->nom ?></h3>
                    <div class="my-2 w-52 h-[2px] bg-gray-300"></div>
                    <p class="text-lg font-text italic text-[#3B3E2E]-600 mb-2"><?= $plat->description ?></p>
                    <p class="text-xl font-bold text-[#3B3E2E]-900"><?= number_format($plat->prix, 2) ?> $</p>
                </div>
            <?php endforeach; ?>
        </div>
    </section>
<?php endforeach; ?>
</div>

<!-- FOOTER -->
<footer id="contact" class="bg-[#3B3E2E] text-white w-full px-4 py-10">
  <div class="max-w-[1100px] mx-auto flex flex-col lg:flex-row flex-wrap justify-between items-center gap-8 text-center lg:text-left">

        <!-- Logo -->
        <div class="flex-shrink-0">
          <img src="public/img/logo.png" alt="Logo Pub G6" class="w-[120px] h-auto mx-auto lg:mx-0">
        </div>
    
        <!-- Infos -->
        <div class="max-w-[400px]">
          <h3 class="font-titre text-2xl mb-2">PUB G6</h3>
          <p class="text-sm leading-snug">
            M. Gaston LeClient<br>
            297, rue St-Georges, Saint-Jérôme (Québec) J7Z 5A2<br>
            Téléphone : 450 436-1531
          </p>
        </div>
    
        <!-- Carte Google Maps -->
        <div class="w-full sm:w-auto max-w-[300px] h-[100px] overflow-hidden rounded">
          <iframe
            class="w-full h-full"
            src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d89015.4680737041!2d-74.12610526275073!3d45.79656902307897!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x4ccf2ca32d386ced%3A0x5040cadae4d5210!2zU2FpbnQtSsOpcsO0bWUsIFFD!5e0!3m2!1sfr!2sca!4v1751295917538!5m2!1sfr!2sca"
            style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade">
          </iframe>
        </div>
    
        <!-- Réseaux sociaux -->
        <div class="flex gap-4">
          <a href="https://www.facebook.com/" aria-label="Facebook">
            <img src="public/img/facebook.png" alt="Facebook" class="w-6 h-6">
          </a>
          <a href="https://www.instagram.com/" aria-label="Instagram">
            <img src="public/img/instagram.png" alt="Instagram" class="w-6 h-6">
          </a>
          <a href="https://x.com/" aria-label="Twitter">
            <img src="public/img/twitter.png" alt="Twitter" class="w-6 h-6">
          </a>
        </div>
    </div>
</footer>
<?php include("views/components/foot.inc.php"); ?>
