<?php $titre = "Accueil | Pub G6"; ?>
<?php include("views/components/head.inc.php"); ?>

<nav class="sticky top-0 left-0 w-full bg-[#3B3E2E]/80 font-texte z-50">
    <div class="max-w-7xl mx-auto px-4 py-4 flex justify-between items-center">

        <!-- Logo -->
        <div>
            <a href="#accueil">
                <img src="public/img/logo.png" alt="Logo" class="h-12">
            </a>
        </div>

        <!-- Bouton hamburger -->
        <button id="menu-btn" class="md:hidden text-white focus:outline-none">
            <svg class="w-8 h-8" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M4 6h16M4 12h16M4 18h16" />
            </svg>
        </button>

        <!-- Liens du menu -->
        <ul id="menu-list" class="hidden md:flex flex-col md:flex-row space-y-4 md:space-y-0 md:space-x-6 text-white text-sm font-medium absolute md:static bg-[#3B3E2E] md:bg-transparent w-full left-0 top-20 px-4 md:px-0 md:w-auto z-40">
            <li><a href="#accueil" class="hover:text-[#4D280C] transition block py-2">ACCUEIL</a></li>
            <li><a href="menu" class="hover:text-[#4D280C] transition block py-2">MENU</a></li>
            <li><a href="#contact" class="hover:text-[#4D280C] transition block py-2">CONTACT</a></li>
            <li><a href="#apropos" class="hover:text-[#4D280C] transition block py-2">À PROPOS</a></li>
        </ul>
    </div>
</nav>

<!-- BACKGROUND IMAGE HERO -->
<header class="relative w-full h-screen bg-cover bg-center" style="background-image: url('public/img/hero1.jpg');">
  <!-- Overlay centré -->
  <div class="absolute inset-0 flex flex-col justify-center items-center text-center px-4">
    
    <!-- Texte avec fond sombre -->
    <div class="bg-[#323122]/60 text-white font-source-sans-pro font-bold
                text-[22px] sm:text-[26px] md:text-[28px] lg:text-[30px] xl:text-[32px]
                leading-tight py-4 px-6 w-full max-w-[900px]">
      Bienvenue chez Pub G6, un établissement emblématique qui a su séduire les gourmets depuis sa fondation il y a 20 ans.
    </div>

    <!-- Flèche blanche -->
    <div class="mt-12 animate-bounce">
        <a href="#apropos">
          <svg xmlns="http://www.w3.org/2000/svg" class="h-20 w-20 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
          </svg>
      </a>
    </div>
</header>


<!-- À PROPOS -->
<section id="apropos" class="bg-white w-full min-h-[600px] pb-20 flex justify-center items-start pt-20">
    <div class="max-w-[1140px] w-full px-6">
        <!-- Titre -->
        <h2 class="text-[50px] font-titre text-[#3B3E2E] text-center mb-12">
            Pub G6
        </h2>
        <!-- Paragraphe principal -->
        <p class="text-[30px] leading-[44px] font-bold font-source-sans-pro text-[#3B3E2E] text-left mb-8">
            Niché au cœur de notre charmante ville, notre restaurant propose une expérience culinaire unique, alliant tradition et innovation. Chaque plat est préparé avec des ingrédients frais et locaux, reflétant notre engagement envers la qualité et l'authenticité.<br><br>
            Au fil des années, Pub G6 est devenu un lieu de rencontre incontournable pour les amoureux de la bonne cuisine. Notre équipe passionnée et talentueuse, dirigée par notre chef renommé, met un point d'honneur à offrir un service chaleureux et attentif. Que vous veniez pour un dîner romantique, une réunion entre amis ou un événement spécial, notre atmosphère conviviale et élégante vous accueillera toujours avec plaisir.
        </p>
        <!-- Bouton LIRE PLUS -->
        <div class="flex justify-center">
            <button id="readMoreBtn"
                class="border border-[#3B3E2E] text-[#3B3E2E] font-semibold px-6 py-2 transition hover:bg-[#3B3E2E] hover:text-white rounded-md cursor-pointer">
                LIRE PLUS
            </button>
        </div>
        <!-- Texte caché -->
        <div id="extraText" class="mt-6 hidden text-[30px] leading-[44px] font-bold font-source-sans-pro text-[#3B3E2E] text-left">
            Nous sommes fiers de notre héritage et de notre évolution constante. En célébrant deux décennies de succès, nous continuons à innover et à réinventer nos menus pour surprendre et ravir nos clients fidèles. Venez découvrir pourquoi le Bistro du Vieux-Port est une véritable institution culinaire, où chaque visite est une fête pour les sens.
        </div>
    </div>
</section>

<!-- MENU CUISINE -->
<section id="cuisine" class="bg-white w-full flex justify-center pt-16">
    <div class="w-full flex flex-col lg:flex-row items-center lg:items-stretch gap-12 px-4 lg:px-0">

        <!-- Image -->
        <div class="w-full lg:w-[50%]">
            <img src="public/img/tartare_legume.jpg" alt="Cuisine"
                class="w-full h-[300px] sm:h-[400px] md:h-[500px] lg:h-[680px] object-cover">
        </div>

        <!-- Bloc texte -->
        <div class="w-full lg:w-[50%] flex items-center justify-center px-4 lg:px-0">
            <div class="font-texte text-[#3B3E2E] max-w-[600px] text-center lg:text-left">
                <!-- Titre -->
                <h2 class="text-[32px] sm:text-[36px] md:text-[40px] lg:text-[44px] font-titre mb-6">LA CUISINE</h2>

                <!-- Texte -->
                <p class="text-[20px] sm:text-[24px] md:text-[28px] leading-snug font-medium mb-4">
                    Découvrez l'âme de notre établissement à travers une cuisine inventive, inspirée par les saveurs locales et la passion du terroir.
                </p>

                <button onclick="window.location.href='menu'"
                    class="mt-4 mb-8 lg:mb-0 border border-[#3B3E2E] text-[#3B3E2E] font-semibold px-6 py-2 transition hover:bg-[#3B3E2E] hover:text-white rounded-md cursor-pointer">
                    VOIR LE MENU
                </button>
            </div>
        </div>
    </div>
</section>

<!-- TÉMOIGNAGES -->
<section class="w-full h-[528px] bg-[#B89C7F] border-t border-[#A4886C] flex justify-center items-center relative overflow-hidden">
    <div class="text-center text-[#3B3E2E] max-w-[800px] px-4">
        <!-- Titre -->
        <h2 class="text-[44px] font-titre mb-6">TÉMOIGNAGES</h2>

        <!-- Témoignage dynamique -->
        <p id="temoignages" class="text-[28px] font-texte italic leading-snug mb-4">
            Excellent service et de la nourriture absolument délicieuse!
        </p>
        <p id="note" class="text-[20px] font-texte font-medium">
            Note : 5/5 étoiles
        </p>

        <!-- Cercles -->
        <div class="flex justify-center gap-3 mt-8">
            <span class="w-4 h-4 rounded-full bg-[#363524] opacity-40 transition-all duration-300" id="dot-0"></span>
            <span class="w-4 h-4 rounded-full bg-[#363524] opacity-40 transition-all duration-300" id="dot-1"></span>
            <span class="w-4 h-4 rounded-full bg-[#363524] opacity-40 transition-all duration-300" id="dot-2"></span>
            <span class="w-4 h-4 rounded-full bg-[#363524] opacity-40 transition-all duration-300" id="dot-3"></span>
            <span class="w-4 h-4 rounded-full bg-[#363524] opacity-40 transition-all duration-300" id="dot-4"></span>
            <span class="w-4 h-4 rounded-full bg-[#363524] opacity-40 transition-all duration-300" id="dot-5"></span>
        </div>
    </div>
</section>

<!-- INFOLETTRE -->
<section class="w-full bg-[#976A3F] flex items-center justify-center py-8 px-6 sm:px-8">
    <div class="w-full max-w-[1600px] flex flex-col lg:flex-row items-start justify-between gap-4 sm:p-8">

        <!-- Texte -->
        <p class="text-white uppercase text-[22px] font-semibold max-w-[700px] mb-4 lg:mb-0 text-left">
            Inscrivez-vous à notre infolettre dès maintenant pour connaître nos nouveautés au menu !
        </p>

        <!-- Formulaire -->
        <form method="POST" action="/projet_web_1/infolettre-enregistrer" class="flex flex-col lg:flex-row items-start gap-4 w-full max-w-[800px]">
            <input type="text" name="nom" placeholder="VOTRE NOM"
                class="bg-white px-3 py-2 rounded-md text-[#21200D] placeholder:text-[#21200D] w-full sm:w-40 md:w-48 lg:w-56 text-sm" required>
            <input type="email" name="courriel" placeholder="VOTRE COURRIEL"
                class="bg-white px-3 py-2 rounded-md text-[#21200D] placeholder:text-[#21200D] w-full sm:w-40 md:w-48 lg:w-56 text-sm" required>

            <!-- Bouton -->
            <button type="submit"
                class="bg-[#3B3E2E] text-white font-semibold px-6 py-2 transition hover:bg-white hover:text-[#3B3E2E] rounded-md cursor-pointer mt-4 lg:mt-0">
                INSCRIPTION
            </button>
        </form>
    </div>
</section>

<!-- FOOTER -->
<footer id="contact" class="bg-[#3B3E2E] text-white w-full px-4 py-6">
    <div class="max-w-[1100px] mx-auto flex flex-col lg:flex-row items-center lg:items-end justify-center lg:justify-between gap-8 text-center lg:text-left">

        <!-- Logo -->
        <div class="flex-shrink-0">
            <img src="public/img/logo.png" alt="Logo Pub G6" class="w-[120px] h-auto mb-2 mx-auto lg:mx-0">
        </div>

        <!-- Infos -->
        <div class="max-w-[400px]">
            <h3 class="font-titre text-2xl mb-2">PUB G6</h3>
            <p class="text-sm leading-snug">
                M. Gaston LeClient<br>
                297, rue St-Georges, Saint-Jérôme (Québec) J7Z 5A2<br>
                Téléphone : 450 436-1531
            </p>
        </div>

        <!-- Carte Google Maps -->
        <div class="w-[250px] h-[120px] overflow-hidden relative rounded">
            <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d89015.4680737041!2d-74.12610526275073!3d45.79656902307897!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x4ccf2ca32d386ced%3A0x5040cadae4d5210!2zU2FpbnQtSsOpcsO0bWUsIFFD!5e0!3m2!1sfr!2sca!4v1751295917538!5m2!1sfr!2sca"
                width="100%" height="100%" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade">
            </iframe>
        </div>

        <!-- Navigation -->
        <div class="flex flex-col gap-1 text-sm hidden lg:flex">
            <a href="index.php" class="hover:underline">ACCUEIL</a>
            <a href="menu" class="hover:underline">MENU</a>
            <a href="index.php#apropos" class="hover:underline">À PROPOS</a>
            <a href="index.php#contact" class="hover:underline">CONTACT</a>
        </div>

        <!-- Réseaux sociaux -->
        <div class="flex gap-4 mt-4 lg:mt-0">
            <a href="https://www.facebook.com/" aria-label="Facebook">
                <img src="public/img/facebook.png" alt="Facebook" class="w-6 h-6">
            </a>
            <a href="https://www.instagram.com/" aria-label="Instagram">
                <img src="public/img/instagram.png" alt="Instagram" class="w-6 h-6">
            </a>
            <a href="https://x.com/" aria-label="Twitter">
                <img src="public/img/twitter.png" alt="Twitter" class="w-6 h-6">
            </a>
        </div>
    </div>
</footer>
<?php include("views/components/foot.inc.php"); ?>