<?php include("views/components/head.inc.php") ?>

<main class="max-w-[1330px] mx-auto py-10 px-4">
    <h1 class="text-4xl font-bold text-gray-800 mb-10 text-center">Menu du restaurant</h1>

    <!-- Lien gestion utilisateurs si propriétaire -->
    <?php if (isset($_SESSION["utilisateurRole"]) && $_SESSION["utilisateurRole"] === "proprietaire"): ?>
        <div class="mb-6 text-right">
            <a href="/projet_web_1/utilisateurs" class="text-sm text-blue-600 hover:underline">🔒 Gestion des utilisateurs</a>
        </div>
    <?php endif; ?>

    <!-- Messages -->
    <?php if (isset($_GET["categorie"])): ?>
        <div class="bg-green-100 text-green-800 px-4 py-2 rounded mb-4 text-sm">Catégorie ajoutée avec succès.</div>
    <?php endif; ?>
    <?php if (isset($_GET["plat"])): ?>
        <div class="bg-green-100 text-green-800 px-4 py-2 rounded mb-4 text-sm">Plat ajouté avec succès.</div>
    <?php endif; ?>
    <?php if (isset($_GET["modif"])): ?>
        <div class="bg-green-100 text-green-800 px-4 py-2 rounded mb-4 text-sm">Modification effectuée avec succès.</div>
    <?php endif; ?>
    <?php if (isset($_GET["delete"])): ?>
        <div class="bg-green-100 text-green-800 px-4 py-2 rounded mb-4 text-sm">Suppression effectuée avec succès.</div>
    <?php endif; ?>

    <!-- Boucle des catégories -->
    <?php foreach ($categories as $categorie): ?>
        <section class="mb-10 bg-white rounded-lg shadow p-6">
            <h2 class="text-2xl font-semibold text-[#3B3E2E] mb-4"><?= htmlspecialchars($categorie->nom) ?></h2>

            <!-- Image de la catégorie -->
            <?php if (!empty($categorie->image)): ?>
                <img src="/projet_web_1/public/img/<?= htmlspecialchars($categorie->image) ?>" 
                     alt="Image de la catégorie <?= htmlspecialchars($categorie->nom) ?>" 
                     class="w-full h-[400px] object-cover rounded-lg mb-6">
            <?php endif; ?>

            <!-- Actions propriétaire -->
            <?php if ($_SESSION["utilisateurRole"] === "proprietaire"): ?>
                <div class="mb-4 flex gap-4 text-sm">
                    <a href="/projet_web_1/categories-modifier?id=<?= $categorie->id ?>&type=categorie" class="text-blue-600 hover:underline">Modifier la catégorie</a>
                    <a href="/projet_web_1/categories-supprimer?id=<?= $categorie->id ?>&type=categorie"
                       onclick="return confirm('Supprimer cette catégorie ?')" 
                       class="text-red-600 hover:underline">Supprimer la catégorie</a>
                </div>
            <?php endif; ?>

            <!-- Plats -->
            <?php if (!empty($categorie->plats)): ?>
                <ul class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-4 text-gray-700">
                    <?php foreach ($categorie->plats as $plat): ?>
                        <li class="border rounded p-4 shadow-sm bg-gray-50">
                            <div class="font-bold text-lg mb-1"><?= htmlspecialchars($plat->nom) ?></div>
                            <div class="text-sm mb-1"><?= htmlspecialchars($plat->description) ?></div>
                            <div class="text-sm font-semibold mb-2"><?= number_format($plat->prix, 2, ',', ' ') ?> $</div>
                            <div class="text-sm">
                                <a href="/projet_web_1/plats-modifier?id=<?= $plat->id ?>&type=plat" class="text-blue-600 hover:underline">Modifier</a> |
                                <a href="/projet_web_1/plats-supprimer?id=<?= $plat->id ?>&type=plat" onclick="return confirm('Supprimer ce plat ?')" class="text-red-600 hover:underline">Supprimer</a>
                            </div>
                        </li>
                    <?php endforeach; ?>
                </ul>
            <?php else: ?>
                <p class="text-sm text-gray-500">Aucun plat dans cette catégorie.</p>
            <?php endif; ?>
        </section>
    <?php endforeach; ?>

    <!-- Liens d'action -->
    <div class="mt-12 space-y-4">
        <a href="/projet_web_1/plats-creer?type=plat" class="inline-block bg-[#3B3E2E] text-white px-6 py-2 rounded hover:bg-[#2c2f20] transition">Ajouter un nouveau plat</a><br>
        <a href="/projet_web_1/categories-creer?type=categorie" class="inline-block bg-[#3B3E2E] text-white px-6 py-2 rounded hover:bg-[#2c2f20] transition">Ajouter une nouvelle catégorie</a><br>
        <a href="/projet_web_1/login" class="inline-block text-gray-500 hover:underline text-sm">← Retour à la connexion</a>
    </div>
</main>

<?php include("views/components/foot.inc.php") ?>
