<?php include("views/components/head.inc.php") ?>

<main class="max-w-3xl mx-auto mt-12 bg-white shadow-lg rounded-2xl p-8">
    <h1 class="text-4xl font-title mb-6 text-center">Modifier un plat</h1>

    <?php if (isset($_GET['erreur'])): ?>
        <div class="text-red-600 text-sm font-semibold mb-4">
            <?php if ($_GET['erreur'] === 'champ'): ?>
                Tous les champs sont obligatoires.
            <?php elseif ($_GET['erreur'] === 'erreur_modification'): ?>
                La modification a échoué. Veuillez réessayer.
            <?php endif; ?>
        </div>
    <?php endif; ?>

    <form action="plats-mettre-a-jour" method="POST" class="space-y-6" novalidate>
        <input type="hidden" name="id" value="<?= htmlspecialchars($plat->id) ?>">
        <input type="hidden" name="type" value="plat">

        <!-- Nom -->
        <div>
            <label for="nom" class="block text-lg font-semibold mb-1">Nom du plat</label>
            <input type="text" id="nom" name="nom"
                   class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:outline-none focus:ring-2 focus:ring-green-600"
                   required
                   value="<?= htmlspecialchars($plat->nom) ?>">
        </div>

        <!-- Description -->
        <div>
            <label for="description" class="block text-lg font-semibold mb-1">Description du plat</label>
            <textarea id="description" name="description" rows="4"
                      class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:outline-none focus:ring-2 focus:ring-green-600"
                      required><?= htmlspecialchars($plat->description) ?></textarea>
        </div>

        <!-- Prix -->
        <div>
            <label for="prix" class="block text-lg font-semibold mb-1">Prix du plat (en $)</label>
            <input type="number" step="0.01" min="0"
                   id="prix" name="prix"
                   class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:outline-none focus:ring-2 focus:ring-green-600"
                   required
                   value="<?= htmlspecialchars($plat->prix) ?>">
        </div>

        <!-- Catégorie -->
        <div>
            <label for="categorie_id" class="block text-lg font-semibold mb-1">Catégorie</label>
            <select id="categorie_id" name="categorie_id" required
                    class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:outline-none focus:ring-2 focus:ring-green-600">
                <option value="">Sélectionner une catégorie</option>
                <?php foreach ($categories as $categorie): ?>
                    <option value="<?= $categorie->id ?>" <?= ($plat->categorie_id == $categorie->id) ? 'selected' : '' ?>>
                        <?= htmlspecialchars($categorie->nom) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <!-- Boutons -->
        <div class="flex justify-between items-center mt-6">
            <button type="submit"
                    class="bg-green-600 hover:bg-green-700 text-white text-lg font-semibold px-6 py-2 rounded-xl shadow">
                Enregistrer les modifications
            </button>
            <a href="admin/menu" class="text-blue-600 hover:underline text-lg">← Retour au menu</a>
        </div>
    </form>
</main>

<?php include("views/components/foot.inc.php") ?>
