<?php include("views/components/head.inc.php") ?>

<main class="max-w-3xl mx-auto mt-12 bg-white shadow-lg rounded-2xl p-8">
    <h1 class="text-4xl font-title mb-6 text-center">Modifier une catégorie</h1>

    <?php if (isset($_GET["erreur"])): ?>
        <div class="text-red-600 text-sm font-semibold mb-4">
            <?php if ($_GET["erreur"] === "champ"): ?>
                Le nom de la catégorie est obligatoire.
            <?php elseif ($_GET["erreur"] === "upload"): ?>
                Erreur lors du téléversement de l’image.
            <?php elseif ($_GET["erreur"] === "erreur_modification"): ?>
                La modification a échoué. Veuillez réessayer.
            <?php endif; ?>
        </div>
    <?php endif; ?>

    <form action="categories-mettre-a-jour" method="POST" enctype="multipart/form-data" class="space-y-6">
        <!-- ID caché -->
        <input type="hidden" name="id" value="<?= htmlspecialchars($categorie->id) ?>">
        <input type="hidden" name="type" value="categorie">

        <!-- Nom -->
        <div>
            <label for="nom" class="block text-lg font-semibold mb-1">Nom</label>
            <input type="text" id="nom" name="nom"
                value="<?= htmlspecialchars($categorie->nom) ?>"
                class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:outline-none focus:ring-2 focus:ring-green-600"
                required>
        </div>

        <!-- Nouvelle image -->
        <div>
            <label for="image" class="block text-lg font-semibold mb-1">Remplacer l’image</label>
            <input type="file" id="image" name="image" accept=".jpg,.jpeg,.png,.webp"
                class="w-full border border-gray-300 rounded-lg px-4 py-2 file:mr-4 file:py-2 file:px-4 file:border-0 file:text-sm file:bg-green-600 file:text-white hover:file:bg-green-700">
        </div>

        <!-- Boutons -->
        <div class="flex items-center justify-between mt-6">
            <button type="submit"
                class="bg-green-600 hover:bg-green-700 text-white text-lg font-semibold px-6 py-2 rounded-xl shadow">
                Enregistrer les modifications
            </button>
            <a href="admin/menu" class="text-blue-600 hover:underline text-lg">← Retour au menu</a>
        </div>
    </form>
</main>

<?php include("views/components/foot.inc.php") ?>