<?php include("views/components/head.inc.php") ?>

<main class="max-w-3xl mx-auto mt-12 bg-white shadow-lg rounded-2xl p-8">
    <h2 class="text-3xl font-title mb-6 text-center">Ajouter un plat</h2>

    <form action="plats-enregistrer" method="POST" class="space-y-6" novalidate>
        <input type="hidden" name="type" value="plat">

        <!-- Nom -->
        <div>
            <label for="nom" class="block text-lg font-semibold mb-1">Nom du plat</label>
            <input type="text" id="nom" name="nom"
                   class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:outline-none focus:ring-2 focus:ring-green-600"
                   placeholder="Nom du plat"
                   required
                   value="<?= htmlspecialchars($_POST['nom'] ?? '') ?>">
        </div>

        <!-- Description -->
        <div>
            <label for="description" class="block text-lg font-semibold mb-1">Description du plat</label>
            <textarea id="description" name="description" rows="4"
                      class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:outline-none focus:ring-2 focus:ring-green-600"
                      placeholder="Description du plat"
                      required><?= htmlspecialchars($_POST['description'] ?? '') ?></textarea>
        </div>

        <!-- Prix -->
        <div>
            <label for="prix" class="block text-lg font-semibold mb-1">Prix du plat (en $)</label>
            <input type="number" step="0.01" min="0"
                   id="prix" name="prix"
                   class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:outline-none focus:ring-2 focus:ring-green-600"
                   placeholder="Prix du plat"
                   required
                   value="<?= htmlspecialchars($_POST['prix'] ?? '') ?>">
        </div>

        <!-- Catégorie -->
        <div>
            <label for="categorie_id" class="block text-lg font-semibold mb-1">Catégorie</label>
            <select id="categorie_id" name="categorie_id" required
                    class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:outline-none focus:ring-2 focus:ring-green-600">
                <option value="">Sélectionner une catégorie</option>
                <?php foreach ($categories as $categorie): ?>
                    <option value="<?= $categorie->id ?>"
                        <?= (isset($_POST['categorie_id']) && $_POST['categorie_id'] == $categorie->id) ? 'selected' : '' ?>>
                        <?= htmlspecialchars($categorie->nom) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <!-- Message d'erreur -->
        <?php if (isset($_GET['erreur']) && $_GET['erreur'] === 'champ'): ?>
            <p class="text-red-600 font-semibold text-sm">Veuillez remplir tous les champs obligatoires.</p>
        <?php endif; ?>

        <!-- Boutons -->
        <div class="flex justify-between items-center mt-6">
            <button type="submit"
                    class="bg-green-600 hover:bg-green-700 text-white text-lg font-semibold px-6 py-2 rounded-xl shadow">
                Créer
            </button>
            <a href="admin/menu" class="text-blue-600 hover:underline text-lg">Annuler</a>
        </div>
    </form>
</main>

<?php include("views/components/foot.inc.php") ?>
