<?php include("views/components/head.inc.php"); ?>

<main class="min-h-screen flex flex-col items-center justify-center bg-gray-100 p-6">
    <div class="bg-white shadow-md rounded-lg max-w-xl w-full p-8">
        <h1 class="text-3xl font-bold text-center text-gray-800 mb-4">Tableau de bord du propriétaire</h1>
        <h2 class="text-lg text-center text-gray-600 mb-6">
            Bienvenue, <span class="font-semibold"><?= htmlspecialchars($_SESSION["utilisateurNom"]) ?></span>!
        </h2>

        <?php if (isset($_GET["succes_modification"])): ?>
            <div class="bg-green-100 text-green-700 p-3 rounded mb-6 text-sm text-center">
                Modification effectuée avec succès.
            </div>
        <?php endif; ?>

        <section class="flex flex-col gap-4">
            <!-- Bouton gérer les utilisateurs -->
            <form action="utilisateurs" method="get">
                <button type="submit" class="w-full bg-[#3B3E2E] text-white py-2 rounded hover:bg-[#2d2f20] transition">
                    Gérer les utilisateurs
                </button>
            </form>

            <!-- Bouton gérer le menu -->
            <form action="admin/menu" method="get">
                <button type="submit" class="w-full bg-[#3B3E2E] text-white py-2 rounded hover:bg-[#2d2f20] transition">
                    Gérer le menu
                </button>
            </form>

            <!-- Lien de déconnexion -->
            <a href="login" class="block text-center text-[#3B3E2E] font-medium mt-4 hover:underline">
                Se déconnecter
            </a>
        </section>
    </div>
</main>

<?php include("views/components/foot.inc.php"); ?>
