<?php

/**
 * Routes disponibles dans le projet
 * 
 * Format: url => [Controller, méthode]
 */
$routes = [

    // === SITE PUBLIC ===
    ""            => ["SiteController", "index"],          // Page d'accueil publique
    "accueil"     => ["SiteController", "index"],          // Alias pour page d'accueil (publique)
    "menu"        => ["SiteController", "menu"],           // Page du menu (publique)

    // === AUTHENTIFICATION ===
    "login"           => ["UtilisateurController", "index"],       // Formulaire de connexion
    "connecter"        => ["UtilisateurController", "connecter"],    // Traitement connexion
    "deconnecter"      => ["UtilisateurController", "deconnecter"],  // Déconnexion

    // === ADMINISTRATEUR (propriétaire) ===
    "admin"                => ["AdminController", "index"],           // Tableau de bord admin
    "admin-utilisateurs"   => ["AdminController", "index"],           // Alias tableau de bord

    // Gestion des utilisateurs (propriétaire uniquement)
    "utilisateurs"             => ["AdminController", "list"],      // Liste utilisateurs
    "utilisateurs-creer"       => ["AdminController", "create"],            // Form création utilisateur
    "utilisateurs-store"       => ["AdminController", "store"],             // Enregistrement nouvel utilisateur
    "utilisateurs-modifier"    => ["AdminController", "edit"],              // Form modification utilisateur
    "utilisateurs-mettre-a-jour" => ["AdminController", "update"],          // Traitement modif utilisateur
    "utilisateurs-supprimer"   => ["AdminController", "destroy"],           // Suppression utilisateur

    // === MENU (propriétaire et employés) ===
    "admin/menu"                => ["MenuController", "index"],                  // Liste catégories + plats

    // Création et gestion des plats
    "plats-creer"          => ["MenuController", "create"],                 // Form création plat
    "plats-enregistrer"    => ["MenuController", "store"],                  // Enregistrement plat
    "plats-modifier"       => ["MenuController", "edit"],                   // Form modification plat
    "plats-mettre-a-jour"  => ["MenuController", "update"],                 // Traitement modif plat
    "plats-supprimer"      => ["MenuController", "destroy"],                // Suppression plat

    // Création et gestion des catégories
    "categories-creer"          => ["MenuController", "create"],            // Form création catégorie
    "categories-enregistrer"    => ["MenuController", "store"],             // Enregistrement catégorie
    "categories-modifier"       => ["MenuController", "edit"],              // Form modif catégorie
    "categories-mettre-a-jour"  => ["MenuController", "update"],            // Traitement modif catégorie
    "categories-supprimer"      => ["MenuController", "destroy"],           // Suppression catégorie

    "infolettre-enregistrer" => ["InfolettreController", "store"],          // Enregistrement infolettre
];
