// ===== Lire plus / Lire moins =====
document.addEventListener("DOMContentLoaded", () => {
  const btn = document.getElementById("readMoreBtn");
  const extraText = document.getElementById("extraText");

  if (btn && extraText) {
    btn.addEventListener("click", () => {
      extraText.classList.toggle("hidden");
      btn.textContent = extraText.classList.contains("hidden") ? "LIRE PLUS" : "LIRE MOINS";
    });
  }

  // ===== Témoignages =====
  const temoignages = [
    {
      text: "Excellent service et de la nourriture absolument délicieuse!",
      note: "Note : 5/5 étoiles"
    },
    {
      text: "Pub G6 est ma destination favorite lorsque je veux recevoir des invités. Fiables et toujours une ambiance très agréable.",
      note: "Note : 5/5 étoiles"
    },
    {
      text: "Même si les prix ne sont pas les plus bas, Pub G6 est une référence dans la qualité du service et de leur mets. Je recommande!",
      note: "Note : 4.5/5 étoiles"
    },
    {
      text: "Woow! Superbe présentation et les meilleures côtes levées que je n’ai jamais mangées!",
      note: "Note : 5/5 étoiles"
    },
    {
      text: "Une expérience agréable et un service de qualité, dommage que ce ne soit pas plus proche!",
      note: "Note : 4/5 étoiles"
    },
    {
      text: "Si vous commandez à boire, demandez les conseils de Kevin! C’est un expert!",
      note: "Note : 5/5 étoiles"
    }
  ];

  let current = 0;

  const temoignagesEl = document.getElementById("temoignages");
  const noteEl = document.getElementById("note");
  const dots = Array.from({ length: 6 }, (_, i) => document.getElementById(`dot-${i}`));

  function showTemoignages(index) {
    if (!temoignagesEl || !noteEl) return;

    const t = temoignages[index];
    temoignagesEl.textContent = t.text;
    noteEl.textContent = t.note;

    dots.forEach((dot, i) => {
      dot.classList.toggle("opacity-100", i === index);
      dot.classList.toggle("opacity-40", i !== index);
    });
  }

  function randomIndex(exclude) {
    let i;
    do {
      i = Math.floor(Math.random() * temoignages.length);
    } while (i === exclude);
    return i;
  }

  function cycleTemoignages() {
    const next = randomIndex(current);
    current = next;
    showTemoignages(current);
  }

  // Démarrer le cycle
  showTemoignages(current);
  setInterval(cycleTemoignages, 4000);

  // ===== Menu hamburger (responsive navbar) =====
  const menuBtn = document.getElementById('menu-btn');
  const menuList = document.getElementById('menu-list');

  if (menuBtn && menuList) {
    menuBtn.addEventListener('click', () => {
      menuList.classList.toggle('hidden');
    });

    // Fermer le menu quand on clique sur un lien (mobile)
    const menuLinks = menuList.querySelectorAll('a');
    menuLinks.forEach(link => {
      link.addEventListener('click', () => {
        if (!menuList.classList.contains('hidden')) {
          menuList.classList.add('hidden');
        }
      });
    });
  }
});
