<?php

namespace Models;

use Bases\Model;

class Utilisateur extends Model {
    protected $table = "utilisateurs";

    /**
     * Retourne un utilisateur à partir de son courriel
     *
     * @param string $courriel
     * @return object|false
     */
    public function byEmail($courriel) {
        $sql = "SELECT *
                FROM $this->table
                WHERE courriel = :courriel";

        $requete = $this->bdd()->prepare($sql);
        $requete->execute([":courriel" => $courriel]);

        return $requete->fetch();
    }

    /**
     * Retourne un utilisateur à partir de son ID (même chose que find)
     *
     * @param int $id
     * @return object|false
     */
    public function byId($id) {
        $sql = "SELECT *
                FROM $this->table
                WHERE id = :id";

        $requete = $this->bdd()->prepare($sql);
        $requete->execute([":id" => $id]);

        return $requete->fetch();
    }
}
