<?php
namespace Models;

use Bases\Model;

class Plat extends Model {
    protected $table = "plats";

    /**
     * Retourne les plats d'une catégorie
     *
     * @param integer $id La catégorie ciblée
     * @return array|false
     */
    public function findByCategory($id) {
        $sql = "SELECT *
                FROM $this->table
                WHERE categorie_id = :id";

        $requete = $this->bdd()->prepare($sql);
        $requete->execute([
            ":id" => $id
        ]);

        return $requete->fetchAll();
    }
}
