<?php

namespace Models;

use Bases\Model;

class Infolettre extends Model
{
    protected $table = "infolettres";

    /**
     * Recherche un enregistrement par email.
     *
     * @param string $email
     * @return object|null
     */
    public function findByEmail(string $email)
    {
        $sql = "SELECT * FROM {$this->table} WHERE email = :email";
        $stmt = $this->bdd()->prepare($sql);
        $stmt->execute(['email' => $email]);
        return $stmt->fetch();
    }

    /**
     * Enregistre un nouvel email dans la table si pas déjà présent.
     *
     * @param string $email
     * @return bool
     */
    public function enregistrerEmail(string $email): bool
    {
        if ($this->findByEmail($email)) {
            // Email déjà existant
            return false;
        }

        return $this->insert(['email' => $email]);
    }
}
