<?php
namespace Models;

use Bases\Model;
use Models\Plat;

class Categorie extends Model {
    protected $table = "categories";

    /**
     * Retourne toutes les catégories avec leurs plats associés
     * sous forme d'un tableau d'objets, chaque catégorie ayant une propriété 'plats'.
     *
     * @return array
     */
    public function allWithPlats()
    {
        // Récupérer toutes les catégories
        $categories = $this->all();
        $platModel = new Plat(); // Instanciation unique

        // Pour chaque catégorie, récupérer ses plats
        foreach ($categories as $categorie) {
           $categorie->plats = $platModel->findByCategory($categorie->id);
        }
        return $categories;
    }
}
