<?php

namespace Controllers;

use Bases\Controller;
use Models\Utilisateur;
use Utils\Upload;

class UtilisateurController extends Controller
{
    /**
     * Affiche le formulaire de connexion
     */
    public function index()
    {
        $this->view("utilisateurs/login");
    }

    /**
     * Traite la connexion
     */
    public function connecter()
    {
        if (empty($_POST["courriel"]) || empty($_POST["mdp"])) {
            $this->rediriger("login?erreur=champs_obligatoires");
        }

        $utilisateur = (new Utilisateur())->byEmail($_POST["courriel"]);

        if (!$utilisateur || !password_verify($_POST["mdp"], $utilisateur->mdp)) {
            $this->rediriger("login?erreur=identifiants_invalides");
        }

        $_SESSION["utilisateurId"] = $utilisateur->id;
        $_SESSION["utilisateurNom"] = $utilisateur->nom;
        $_SESSION["utilisateurRole"] = $utilisateur->role;
        $_SESSION["estConnecte"] = true;

        if ($utilisateur->role === "proprietaire") {
            $this->rediriger("admin");
        } else {
            $this->rediriger("admin/menu");
        }
    }

    /**
     * Déconnecte l'utilisateur
     */
    public function deconnecter()
    {
        session_destroy();
        $this->rediriger("login?succes_deconnexion");
    }

    /**
     * Affiche le formulaire de création de compte
     */
    public function create()
    {
        $this->view("utilisateurs/create");
    }

    /**
     * Enregistre un nouvel utilisateur
     */
    public function store()
    {
        if (
            empty($_POST["nom"]) ||
            empty($_POST["courriel"]) ||
            empty($_POST["mdp"])
        ) {
            $this->rediriger("utilisateurs-creer?infos_requises");
        }

        $utilisateur = new Utilisateur();

        $utilisateur->insert([
            "nom" => $_POST["nom"],
            "courriel" => $_POST["courriel"],
            "mdp" => password_hash($_POST["mdp"], PASSWORD_DEFAULT),
            "role" => "employe"
        ]);

        $this->rediriger("?compte_cree");
    }
}
