<?php

namespace Controllers;

use Bases\Controller;
use Models\Categorie;
use Models\Plat;
use Utils\Upload;

class MenuController extends Controller
{
    public function index()
    {
        $categories = (new Categorie())->allWithPlats();
        $this->view("menu/index", ["categories" => $categories]);
    }


    public function create()
    {
        $type = $_GET["type"] ?? "plat";
        $categories = (new Categorie())->all();

        if ($type === "categorie") {
            $this->view("menu/create-categorie", ["categories" => $categories]);
        } else {
            $this->view("menu/create-plat", ["categories" => $categories]);
        }
    }

    public function store()
    {
        $type = $_POST["type"] ?? "plat";

        if (
            empty($_POST["nom"]) ||
            ($type === "plat" && (empty($_POST["description"]) || empty($_POST["prix"]) || empty($_POST["categorie_id"])))
        ) {
            $this->rediriger("menu?erreur=champ");
        }

        if ($type === "categorie") {
            $data = ["nom" => $_POST["nom"]];

            if (!empty($_FILES["image"]["name"])) {
                $upload = new Upload("image", ["jpg", "jpeg", "png", "webp"]);
                $chemin = $upload->placerDans("public/img");

                if ($chemin) {
                    $data["image"] = basename($chemin);
                } else {
                    $this->rediriger("create-categorie?erreur=upload");
                }
            }

            if ((new Categorie())->insert($data)) {
                $this->rediriger("menu?categorie");
            } else {
                $this->rediriger("menu?erreur_creation");
            }
        } else {
            if ((new Plat())->insert([
                "nom" => $_POST["nom"],
                "description" => $_POST["description"],
                "prix" => $_POST["prix"],
                "categorie_id" => $_POST["categorie_id"]
            ])) {
                $this->rediriger("menu?plat");
            } else {
                $this->rediriger("menu?erreur_creation");
            }
        }
    }

    public function edit()
    {
        if (empty($_GET["id"]) || empty($_GET["type"])) {
            $this->rediriger("menu?erreur_id_manquant");
        }

        $id = $_GET["id"];
        $type = $_GET["type"];

        if ($type === "categorie") {
            $categorie = (new Categorie())->find($id);
            if (!$categorie) $this->rediriger("menu?introuvable");

            $this->view("menu/edit-categorie", ["categorie" => $categorie]);
        } else {
            $plat = (new Plat())->find($id);
            if (!$plat) $this->rediriger("menu?introuvable");

            $categories = (new Categorie())->all();
            $this->view("menu/edit-plat", [
                "plat" => $plat,
                "categories" => $categories
            ]);
        }
    }

    public function update()
    {
        if (empty($_POST["id"]) || empty($_POST["type"])) {
            $this->rediriger("menu?erreur_id_manquant");
        }

        $id = $_POST["id"];
        $type = $_POST["type"];

        if ($type === "categorie") {
            if (empty($_POST["nom"])) {
                $this->rediriger("modifier?id=$id&type=categorie&erreur=champ");
            }

            $categorieModel = new Categorie();
            $categorie = $categorieModel->find($id);
            if (!$categorie) $this->rediriger("menu?introuvable");

            $data = ["nom" => $_POST["nom"]];

            if (!empty($_FILES["image"]["name"])) {
                $upload = new Upload("image", ["jpg", "jpeg", "png", "webp"]);
                $chemin = $upload->placerDans("public/img");

                if ($chemin) {
                    $data["image"] = basename($chemin);

                    if (!empty($categorie->image) && file_exists("public/img/" . $categorie->image)) {
                        unlink("public/img/" . $categorie->image);
                    }
                } else {
                    $this->rediriger("modifier?id=$id&type=categorie&erreur=upload");
                }
            }

            if ($categorieModel->update($id, $data)) {
                $this->rediriger("menu?modif");
            } else {
                $this->rediriger("modifier?id=$id&type=categorie&erreur=erreur_modification");
            }
        } else {
            if (
                empty($_POST["nom"]) ||
                empty($_POST["description"]) ||
                empty($_POST["prix"]) ||
                empty($_POST["categorie_id"])
            ) {
                $this->rediriger("modifier?id=$id&type=plat&erreur=champ");
            }

            if ((new Plat())->update($id, [
                "nom" => $_POST["nom"],
                "description" => $_POST["description"],
                "prix" => $_POST["prix"],
                "categorie_id" => $_POST["categorie_id"]
            ])) {
                $this->rediriger("menu?modif");
            } else {
                $this->rediriger("modifier?id=$id&type=plat&erreur=erreur_modification");
            }
        }
    }

    public function destroy()
    {
        if (empty($_GET["id"]) || empty($_GET["type"])) {
            $this->rediriger("menu?erreur_id_manquant");
        }

        $id = $_GET["id"];
        $type = $_GET["type"];

        if ($type === "categorie") {
            $categorie = (new Categorie())->find($id);

            if ((new Categorie())->destroy($id)) {
                if (!empty($categorie->image) && file_exists("public/img/" . $categorie->image)) {
                    unlink("public/img/" . $categorie->image);
                }
                $this->rediriger("menu?delete");
            } else {
                $this->rediriger("menu?erreur_suppression");
            }
        } else {
            if ((new Plat())->destroy($id)) {
                $this->rediriger("menu?delete");
            } else {
                $this->rediriger("menu?erreur_suppression");
            }
        }
    }
}
