<?php
namespace Controllers;

use Bases\Controller;
use Models\Infolettre;

class InfolettreController extends Controller
{
    public function store()
    {
        if (empty($_POST["courriel"])) {
            $this->rediriger("accueil?erreur=champs_obligatoires");
        }

        $courriel = trim($_POST["courriel"]);

        if (!filter_var($courriel, FILTER_VALIDATE_EMAIL)) {
            $this->rediriger("accueil?erreur=email_invalide");
        }

        $infolettre = new Infolettre();

        // Vérifie si email déjà enregistré
        if ($infolettre->findByEmail($courriel)) {
            $this->rediriger("accueil?erreur=email_existe");
        }

        $result = $infolettre->enregistrerEmail($courriel);

        if ($result) {
            $this->rediriger("accueil?success=inscription");
        } else {
            $this->rediriger("accueil?erreur=echec_insertion");
        }
    }
}
