<?php

namespace Controllers;

use Bases\Controller;
use Models\Utilisateur;

class AdminController extends Controller
{
    /**
     * Affiche le tableau de bord du propriétaire.
     */
    public function index()
    {
        $this->view("admin/index");
    }

    /**
     * Affiche la liste des utilisateurs.
     */
    public function list()
    {
        $utilisateurs = (new Utilisateur())->all();

        $this->view("utilisateurs/index", [
            "utilisateurs" => $utilisateurs
        ]);
    }

    /**
     * Affiche le formulaire de création.
     */
    public function create()
    {
       $this->view("utilisateurs/create");
    }

    /**
     * Traite la création.
     */
    public function store()
    {
        
        if (empty($_POST["nom"]) || empty($_POST["courriel"]) || empty($_POST["mdp"])) {
            $this->rediriger("utilisateurs-creer?infos_requises");
        }

        $resultat = (new Utilisateur())->insert([
            "nom"      => $_POST["nom"],
            "courriel" => $_POST["courriel"],
            "mdp"      => password_hash($_POST["mdp"], PASSWORD_DEFAULT),
            "role"     => $_POST["role"] ?? "employe"
        ]);

        if ($resultat) {
            $this->rediriger("utilisateurs?succes_creation");
        } else {
            $this->rediriger("utilisateurs-creer?erreur_creation");
        }
    }

    /**
     * Affiche le formulaire d'édition.
     */
    public function edit()
    {
    
        if (empty($_GET["id"])) {
            $this->rediriger("utilisateurs?erreur_id_manquant");
        }

        $utilisateur = (new Utilisateur())->find($_GET["id"]);

        if (!$utilisateur) {
            $this->rediriger("utilisateurs?introuvable");
        }

        $this->view("utilisateurs/edit", [
            "utilisateur" => $utilisateur
        ]);
    }

    /**
     * Traite la mise à jour.
     */
    public function update()
    {

        if (empty($_POST["id"]) || empty($_POST["nom"]) || empty($_POST["courriel"])) {
            $this->rediriger("utilisateurs-modifier?id=" . $_POST["id"] . "&infos_requises");
        }

        $resultat = (new Utilisateur())->update($_POST["id"], [
            "nom"      => $_POST["nom"],
            "courriel" => $_POST["courriel"],
            "role"     => $_POST["role"] ?? "employe"
        ]);

        if ($resultat) {
            $this->rediriger("utilisateurs?succes_modification");
        } else {
            $this->rediriger("utilisateurs-modifier?id=" . $_POST["id"] . "&erreur_modification");
        }
    }

    /**
     * Supprime un utilisateur.
     */
    public function destroy()
    {

        if (empty($_GET["id"])) {
            $this->rediriger("utilisateurs?erreur_id_manquant");
        }

        $resultat = (new Utilisateur())->destroy($_GET["id"]);

        if ($resultat) {
            $this->rediriger("utilisateurs?succes_suppression");
        } else {
            $this->rediriger("utilisateurs?erreur_suppression");
        }
    }

    /**
     * Déconnecte l'admin
     */
    public function deconnecter()
    {
        session_destroy();
        $this->rediriger("login?succes_deconnexion");
    }
}
