<?php

namespace Bases;

class Controller {
    /**
     * Prend en charge les routes inexistantes et affiche une erreur 404
     * 
     * @return void
     */
    public function erreur404() {
        $this->view("erreurs/404", [
            "titre" => "Page introuvable"
        ]);
    }

    /**
     * Redirige à l'URL fourni
     *
     * @param string $url
     * @return void
     */
    protected function rediriger($url) {
        header("location: $url");
        exit();
    }

    /**
     * Inclut la vue spécifiée
     *
     * @param string $chemin
     * @param array $donnees
     * @return void
     */
    protected function view($chemin, $donnees = []) {
        extract($donnees);
        include("views/$chemin.view.php");
    }

    /**
     * Protège la route avec une connexion
     *
     * @param string $url URL où rediriger
     * 
     * @return void
     */
    protected function proteger($url){
        if(!isset($_SESSION["estConnecte"]) || $_SESSION["estConnecte"] != true){
            $this->rediriger($url);
            exit;
        }
    }
    /**
     * Vérifie si l'utilisateur est connecté
     *
     * @return bool
     */
    protected function estConnecte() {
        return isset($_SESSION["estConnecte"]) && $_SESSION["estConnecte"] === true;
    }

    /**
     * Vérifie si l'utilisateur est propriétaire
     *
     * @return bool
     */
   protected function estProprietaire() {
    return isset($_SESSION["utilisateurRole"]) && $_SESSION["utilisateurRole"] === "proprietaire";
    }
}